// Diag1.cpp : implementation file
//

#include "stdafx.h"
#include "wcsohr_menu.h"
#include "Diag1.h"

#include "BtnST.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// Diag1 dialog

CButtonST* m_IDOK;
int x_IDOK = 175+73-39+9;
int y_IDOK = 275-9+16;
int xs_IDOK = x_IDOK + 106 - 27 - 17;
int ys_IDOK = y_IDOK + 40 - 8;

CButtonST* res640;
int x_640 = 69-46;
int y_640 = 236+13-82-81+3;
int xs_640 = x_640 + 123 - 19;
int ys_640 = y_640 + 34;

CButtonST* res800;
int x_800 = 69 - 46;
int y_800 = 236+13-82-81+51;
int xs_800 = x_800 + 123 - 19;
int ys_800 = y_800 + 34;

CButtonST* res1024;
int x_1024 = 69 - 45;
int y_1024 = 236+13-82-81+99;
int xs_1024 = x_1024 + 123 + 6 - 25;
int ys_1024 = y_1024 + 33;

CButtonST* modesw;
int x_modesw = 288+25+119-73;
int y_modesw = 236+13-82-87+13;
int xs_modesw = x_modesw + 203 - 54 - 28;
int ys_modesw = y_modesw + 41 - 9;

CButtonST* modeglide;
int x_modeglide = 288+25+119-73+30;
int y_modeglide = 236+13-82-87+13+48;
int xs_modeglide = x_modeglide + 203 - 54 - 28 - 56;
int ys_modeglide = y_modeglide + 41 - 9;

CButtonST* moded3d;
int x_moded3d = 288+25+119-73-31;
int y_moded3d = 236+13-82-87+13+48+48;
int xs_moded3d = x_moded3d + 168 + 18;
int ys_moded3d = y_moded3d + 29;

CButtonST* moded3d_32;
int x_moded3d_32 = 288+25+119-73-32;
int y_moded3d_32 = 236+13-82-87+13+48+48+47;
int xs_moded3d_32 = x_moded3d_32 + 168 + 18;
int ys_moded3d_32 = y_moded3d_32 + 29;


Diag1::Diag1(CWnd* pParent /*=NULL*/)
	: CDialog(Diag1::IDD, pParent)
{
	//{{AFX_DATA_INIT(Diag1)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}


void Diag1::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(Diag1)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(Diag1, CDialog)
	//{{AFX_MSG_MAP(Diag1)
	ON_BN_CLICKED(IDC_RES1024, OnRes1024)
	ON_BN_CLICKED(IDC_RES640, OnRes640)
	ON_BN_CLICKED(IDC_RES800, OnRes800)
	ON_BN_CLICKED(IDC_MODESW, OnModesw)
	ON_BN_CLICKED(IDC_MODEGLIDE, OnModeglide)
	ON_BN_CLICKED(IDC_MODED3D, OnModed3d)
	ON_BN_CLICKED(IDC_MODED3D_32, OnModed3d32)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// Diag1 message handlers

void Diag1::OnOK() 
{

if (res640->GetCheck())	r640 = true; else r640 = false;
if (res800->GetCheck())	r800 = true; else r800 = false;
if (res1024->GetCheck())	r1024 = true; else r1024 = false;

if (modesw->GetCheck())	msw = true;	else	msw = false;
if (moded3d->GetCheck())	md3d = true;	else	md3d = false;
if (moded3d_32->GetCheck())	md3d_32 = true;	else	md3d_32 = false;
if (modeglide->GetCheck())	mglide = true;	else	mglide = false;



if ( (res640->GetCheck() || res800->GetCheck() || res1024->GetCheck() ) && 
	 (modesw->GetCheck() || moded3d->GetCheck()|| moded3d_32->GetCheck() || modeglide->GetCheck()) )
{
	if (modesw->GetCheck() && !res640->GetCheck() )
		MessageBox ("Only 640x480 is available for software mode");
	else
	{
		FILE * f = fopen("menu.cfg", "wt");
		
		if (f)
		{
			if (res640->GetCheck()) fprintf(f,"0 ");
			if (res800->GetCheck()) fprintf(f,"1 ");
			if (res1024->GetCheck()) fprintf(f,"2 ");

			if (modesw->GetCheck()) fprintf(f,"0 ");
			if (moded3d->GetCheck()) fprintf(f,"1 ");
			if (modeglide->GetCheck()) fprintf(f,"2 ");
			if (moded3d_32->GetCheck()) fprintf(f,"3 ");
			fclose(f);
		}

		CDialog::OnOK();
	}
}

else
	MessageBox ("Please choose a resolution and video driver first");

}


BOOL Diag1::OnChildNotify(UINT message, WPARAM wParam, LPARAM lParam, LRESULT* pLResult) 
{
	FILE * f = fopen ("menu.cfg", "rt");
	if (f)
	{
		int res, driver;
		
		fscanf(f, "%d %d ", &res, &driver);
		fclose(f);

		switch (res)
		{
		default:
		case 0:
			res640->SetCheck(1);
			res800->SetCheck(0);
			res1024->SetCheck(0);
			break;
		case 1:
			res640->SetCheck(0);
			res800->SetCheck(1);
			res1024->SetCheck(0);
			break;
		case 2:
			res640->SetCheck(0);
			res800->SetCheck(0);
			res1024->SetCheck(1);
			break;
		}


		switch (driver)
		{
		case 0:
			modesw->SetCheck(1);
			moded3d->SetCheck(0);
			moded3d_32->SetCheck(0);
			modeglide->SetCheck(0);
			break;
		default:
		case 1:
			modesw->SetCheck(0);
			moded3d->SetCheck(1);
			moded3d_32->SetCheck(0);
			modeglide->SetCheck(0);
			break;
		case 2:
			modesw->SetCheck(0);
			moded3d->SetCheck(0);
			moded3d_32->SetCheck(0);
			modeglide->SetCheck(1);
			break;
		case 3:
			modesw->SetCheck(0);
			moded3d->SetCheck(0);
			moded3d_32->SetCheck(1);
			modeglide->SetCheck(0);
			break;
		}
	}	
	else
	{
		res640->SetCheck(1);
		moded3d->SetCheck(1);
	}

	return CDialog::OnChildNotify(message, wParam, lParam, pLResult);
}

BOOL Diag1::PreCreateWindow(CREATESTRUCT& cs) 
{
	return CDialog::PreCreateWindow(cs);
}

BOOL Diag1::OnInitDialog() 
{
	CDialog::OnInitDialog();

	// Create the IDOK button
	m_IDOK = new CButtonST;
	m_IDOK->Create(/*_T("Play")*/ _T(" "), WS_CHILD | WS_VISIBLE | WS_GROUP | WS_TABSTOP, CRect(x_IDOK, y_IDOK, xs_IDOK, ys_IDOK), this, IDOK);
	// Set the same font of the application
	m_IDOK->SetColor(CButtonST::BTNST_COLOR_BK_IN, RGB(0,0,0));
	m_IDOK->SetColor(CButtonST::BTNST_COLOR_BK_OUT, RGB(0,0,0));
	m_IDOK->SetColor(CButtonST::BTNST_COLOR_BK_FOCUS, RGB(0,0,0));
	m_IDOK->SetColor(CButtonST::BTNST_COLOR_FG_IN, RGB(255,255,255));
	m_IDOK->SetColor(CButtonST::BTNST_COLOR_FG_OUT, RGB(255,255,255));
	m_IDOK->SetColor(CButtonST::BTNST_COLOR_FG_FOCUS, RGB(255,255,255));
	m_IDOK->DrawTransparent();
	m_IDOK->SetFont(GetFont());

	res640 = new CButtonST;
	res640->Create(/*_T("640x480")*/ _T(" "), BS_CHECKBOX |  WS_CHILD | WS_VISIBLE | WS_GROUP | WS_TABSTOP, CRect(x_640, y_640, xs_640, ys_640), this, IDC_RES640);
	res640->SetColor(CButtonST::BTNST_COLOR_BK_IN, RGB(0,0,0));
	res640->SetColor(CButtonST::BTNST_COLOR_BK_OUT, RGB(0,0,0));
	res640->SetColor(CButtonST::BTNST_COLOR_BK_FOCUS, RGB(0,0,0));
	res640->SetColor(CButtonST::BTNST_COLOR_FG_IN, RGB(255,255,255));
	res640->SetColor(CButtonST::BTNST_COLOR_FG_OUT, RGB(255,255,255));
	res640->SetColor(CButtonST::BTNST_COLOR_FG_FOCUS, RGB(255,255,255));
	res640->SetFont(GetFont());
	res640->DrawTransparent();
	res640->SetCheck(0);

	res800 = new CButtonST;
	res800->Create(/*_T("800x600")*/ _T(" "), BS_CHECKBOX |  WS_CHILD | WS_VISIBLE | WS_GROUP | WS_TABSTOP, CRect(x_800, y_800, xs_800, ys_800), this, IDC_RES800);
	res800->SetColor(CButtonST::BTNST_COLOR_BK_IN, RGB(0,0,0));
	res800->SetColor(CButtonST::BTNST_COLOR_BK_OUT, RGB(0,0,0));
	res800->SetColor(CButtonST::BTNST_COLOR_BK_FOCUS, RGB(0,0,0));
	res800->SetColor(CButtonST::BTNST_COLOR_FG_IN, RGB(255,255,255));
	res800->SetColor(CButtonST::BTNST_COLOR_FG_OUT, RGB(255,255,255));
	res800->SetColor(CButtonST::BTNST_COLOR_FG_FOCUS, RGB(255,255,255));
	res800->SetFont(GetFont());
	res800->DrawTransparent();
	res800->SetCheck(0);

	res1024 = new CButtonST;
	res1024->Create(/*_T("1024x768")*/ _T(" "), BS_CHECKBOX |  WS_CHILD | WS_VISIBLE | WS_GROUP | WS_TABSTOP, CRect(x_1024, y_1024, xs_1024, ys_1024), this, IDC_RES1024);
	res1024->SetColor(CButtonST::BTNST_COLOR_BK_IN, RGB(0,0,0));
	res1024->SetColor(CButtonST::BTNST_COLOR_BK_OUT, RGB(0,0,0));
	res1024->SetColor(CButtonST::BTNST_COLOR_BK_FOCUS, RGB(0,0,0));
	res1024->SetColor(CButtonST::BTNST_COLOR_FG_IN, RGB(255,255,255));
	res1024->SetColor(CButtonST::BTNST_COLOR_FG_OUT, RGB(255,255,255));
	res1024->SetColor(CButtonST::BTNST_COLOR_FG_FOCUS, RGB(255,255,255));
	res1024->SetFont(GetFont());
	res1024->DrawTransparent();
	res1024->SetCheck(0);

	modesw = new CButtonST;
	modesw->Create(/*_T("Software")*/ _T(" "), BS_CHECKBOX |  WS_CHILD | WS_VISIBLE | WS_GROUP | WS_TABSTOP, CRect(x_modesw, y_modesw, xs_modesw, ys_modesw), this, IDC_MODESW);
	modesw->SetColor(CButtonST::BTNST_COLOR_BK_IN, RGB(0,0,0));
	modesw->SetColor(CButtonST::BTNST_COLOR_BK_OUT, RGB(0,0,0));
	modesw->SetColor(CButtonST::BTNST_COLOR_BK_FOCUS, RGB(0,0,0));
	modesw->SetColor(CButtonST::BTNST_COLOR_FG_IN, RGB(255,255,255));
	modesw->SetColor(CButtonST::BTNST_COLOR_FG_OUT, RGB(255,255,255));
	modesw->SetColor(CButtonST::BTNST_COLOR_FG_FOCUS, RGB(255,255,255));
	modesw->SetFont(GetFont());
	modesw->DrawTransparent();
	modesw->SetCheck(0);
	
	moded3d = new CButtonST;
	moded3d->Create(/*_T("Direct3D")*/ _T(" "), BS_CHECKBOX |  WS_CHILD | WS_VISIBLE | WS_GROUP | WS_TABSTOP, CRect(x_moded3d, y_moded3d, xs_moded3d, ys_moded3d), this, IDC_MODED3D);
	moded3d->SetColor(CButtonST::BTNST_COLOR_BK_IN, RGB(0,0,0));
	moded3d->SetColor(CButtonST::BTNST_COLOR_BK_OUT, RGB(0,0,0));
	moded3d->SetColor(CButtonST::BTNST_COLOR_BK_FOCUS, RGB(0,0,0));
	moded3d->SetColor(CButtonST::BTNST_COLOR_FG_IN, RGB(255,255,255));
	moded3d->SetColor(CButtonST::BTNST_COLOR_FG_OUT, RGB(255,255,255));
	moded3d->SetColor(CButtonST::BTNST_COLOR_FG_FOCUS, RGB(255,255,255));
	moded3d->SetFont(GetFont());
	moded3d->DrawTransparent();
	moded3d->SetCheck(0);

	moded3d_32 = new CButtonST;
	moded3d_32->Create(/*_T("Direct3D")*/ _T(" "), BS_CHECKBOX |  WS_CHILD | WS_VISIBLE | WS_GROUP | WS_TABSTOP, CRect(x_moded3d_32, y_moded3d_32, xs_moded3d_32, ys_moded3d_32), this, IDC_MODED3D_32);
	moded3d_32->SetColor(CButtonST::BTNST_COLOR_BK_IN, RGB(0,0,0));
	moded3d_32->SetColor(CButtonST::BTNST_COLOR_BK_OUT, RGB(0,0,0));
	moded3d_32->SetColor(CButtonST::BTNST_COLOR_BK_FOCUS, RGB(0,0,0));
	moded3d_32->SetColor(CButtonST::BTNST_COLOR_FG_IN, RGB(255,255,255));
	moded3d_32->SetColor(CButtonST::BTNST_COLOR_FG_OUT, RGB(255,255,255));
	moded3d_32->SetColor(CButtonST::BTNST_COLOR_FG_FOCUS, RGB(255,255,255));
	moded3d_32->SetFont(GetFont());
	moded3d_32->DrawTransparent();
	moded3d_32->SetCheck(0);
	
	modeglide = new CButtonST;
	modeglide->Create(/*_T("Glide")*/ _T(" "), BS_CHECKBOX |  WS_CHILD | WS_VISIBLE | WS_GROUP | WS_TABSTOP, CRect(x_modeglide, y_modeglide, xs_modeglide, ys_modeglide), this, IDC_MODEGLIDE);
	modeglide->SetColor(CButtonST::BTNST_COLOR_BK_IN, RGB(0,0,0));
	modeglide->SetColor(CButtonST::BTNST_COLOR_BK_OUT, RGB(0,0,0));
	modeglide->SetColor(CButtonST::BTNST_COLOR_BK_FOCUS, RGB(0,0,0));
	modeglide->SetColor(CButtonST::BTNST_COLOR_FG_IN, RGB(255,255,255));
	modeglide->SetColor(CButtonST::BTNST_COLOR_FG_OUT, RGB(255,255,255));
	modeglide->SetColor(CButtonST::BTNST_COLOR_FG_FOCUS, RGB(255,255,255));
	modeglide->SetFont(GetFont());
	modeglide->DrawTransparent();
	modeglide->SetCheck(0);

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}


void Diag1::OnRes640() 
{
	res640->SetCheck(1);
	res800->SetCheck(0);
	res1024->SetCheck(0);
}

void Diag1::OnRes800() 
{
	res640->SetCheck(0);
	res800->SetCheck(1);
	res1024->SetCheck(0);
}

void Diag1::OnRes1024() 
{
	res640->SetCheck(0);
	res800->SetCheck(0);
	res1024->SetCheck(1);
}

void Diag1::OnModesw() 
{
	modesw->SetCheck(1);
	moded3d->SetCheck(0);
	moded3d_32->SetCheck(0);
	modeglide->SetCheck(0);
}

void Diag1::OnModeglide() 
{
	modesw->SetCheck(0);
	moded3d->SetCheck(0);
	moded3d_32->SetCheck(0);
	modeglide->SetCheck(1);
}

void Diag1::OnModed3d() 
{
	modesw->SetCheck(0);
	moded3d->SetCheck(1);
	moded3d_32->SetCheck(0);
	modeglide->SetCheck(0);
}

void Diag1::OnModed3d32() 
{
	modesw->SetCheck(0);
	moded3d->SetCheck(0);
	moded3d_32->SetCheck(1);
	modeglide->SetCheck(0);

}
